-- Owner für DemoDaten
SET SESSION AUTHORIZATION 'DEMODATA';

-- Warenwirtschaft: Standardprozess: Verkauf (Rahmen und Abruf) > PA > ABK, Lager
  DO $$
    DECLARE
        s VARCHAR;
        myident                                 VARCHAR:=current_user;
        --Datum --TODO: ACHTUNG ALLE DATUM: ABFANGEN DAS AUF WOCHENENDE
            dat_folgejahr                       DATE:= current_date + interval '1 year';
            dat_monat_folgemonat_erster         DATE:=(SELECT date_trunc('month', current_date + interval '1 month')); --  01. des Folgemonats --achtung dat_current_plus_1_monat
            dat_current_minus_2_monat           DATE:=current_date - interval '2 month';
            dat_current_minus_1_monat           DATE:=current_date - interval '1 month';
            dat_current_minus_1_week            DATE:=current_date - interval '1 week';
            dat_current_minus_5_day             DATE:=current_date-5;
            dat_current_plus_15_day             DATE:=current_date+15;
            dat_current_plus_1_monat            DATE:=current_date + interval '1 month'; --achtung dat_monat_folgemonat_erster
        --Artikel
            art_getriebe                        VARCHAR :='G.PKW.A-1168534 /A';
            art_getriebe_mgcid                  INTEGER :=tartikel.me__art__artmgc__m_id__by__ak_standard_mgc(art_getriebe);
            art_welle                           VARCHAR :='W.13.N-272.371 /C';
            art_welle_mgcid                     INTEGER :=tartikel.me__art__artmgc__m_id__by__ak_standard_mgc(art_welle);
            art_welle_mgcid_iso_palt_10         VARCHAR :='Palt. 10';
            art_welle_mgcid_palt_10             INTEGER:=tartikel.me__art__artmgc__m_id__by__me_iso(art_welle, art_welle_mgcid_iso_palt_10);
            --art_welle_mgcid_palette
            art_bc_getriebe_sensor              VARCHAR :='E.B.PKW.A-1168534-0100 /A';
            art_bc_getriebe_sensor_mgcid        INTEGER :=tartikel.me__art__artmgc__m_id__by__ak_standard_mgc(art_bc_getriebe_sensor);
            --2 weitere für Positionsgenerierung: Lagerzugang tabellarisch usw.
            art_bc_platine                      VARCHAR :='E.B.PKW.A-1168534-0001 /A';
            art_bc_platine_mgcid                INTEGER :=tartikel.me__art__artmgc__m_id__by__ak_standard_mgc(art_bc_platine);
            --L Profil mit Zuschnitt
            art_lprofil                         VARCHAR :='L.100X1000-0001';
            art_lprofil_mgcid                   INTEGER :=tartikel.me__art__artmgc__m_id__by__ak_standard_mgc(art_lprofil);
            --Zahnrad
            art_zahnrad                         VARCHAR :='Z-21435000-L-Z64';
            art_zahnrad_mgcid                   INTEGER :=tartikel.me__art__artmgc__m_id__by__ak_standard_mgc(art_zahnrad);

        --Adressen
            adk_kunde_auto                      VARCHAR :='AUTO-AG';
            adk_kunde_getr                      VARCHAR :='GETRIEBE-GMBH';
            adk_lief_elek                       VARCHAR :='ELEKTR';
            adk_lief_zersp                      VARCHAR :='ZERSP';
            adk_lief_stahl                      VARCHAR :='STAHL';
        --Sonstiges
            steu_steucode_auftg                 INTEGER :=TSystem.Settings__Get('auftgsteucode');
            rahmen_ident                        VARCHAR :='RAH-0011';
        --Verkauf
            auftg_rahmen_ag_id                  INTEGER; --zuweisen durch returning bei insert into auftg

            auftg_welle_ag_id_plus15            INTEGER;
        --Einkauf, ABK
            ldsdoki_welle_ld_id_plus15          INTEGER;
            ldsdoki_welle_abix_plus15           INTEGER;
            ldsdoke_ld_id_getriebe_sensor       INTEGER;
            ldsdoke_ld_id                       INTEGER;
            ldsdokr_ld_id_art_rahnrad           INTEGER;
            ldsdokr_ld_id_art_eahnrad           INTEGER;

            ldsdoke_dbrid                       VARCHAR(32);
            ldsdoke_ld_auftg                    VARCHAR(30);
            ldsdoke_erg_nr                      VARCHAR(30);
            ldsdoke_ltd_dokunr                  INTEGER;

            ldsdoke_sernrident                  VARCHAR := 'SERNR-'||current_date;
            auftg_welle_ag_id_palt10            INTEGER;
        --Materialeinkauf
          mat_aknr                              VARCHAR(40)      := '1.2210 Ø14X1000';
            mat_bez                             VARCHAR        := '115CrV3';
            mat_ld_auftg                        VARCHAR(30);
            mat_preis                           NUMERIC;
            kg_mgcode_me_cod                    INTEGER;
            kg_ld_ekp_mce                       INTEGER;
            s3m_mgcode_me_cod                   INTEGER;
            s3m_ld_ekp_mce                      INTEGER;
            mat_stk                             INTEGER;
            mat_ld_id                           INTEGER;
            --mat_l_abgg    NUMERIC;    -- Lagerabgang
            mat_lifsch_dbrid                   VARCHAR(32);
            mat_beld_dokunr                    VARCHAR(30);
            mat_be_bnr                         VARCHAR(15);
            mat_lfs_pos_id                     INTEGER;
            mat_pos                            INTEGER;
            mat_ltd_dokunr                     INTEGER;
            mat_erg_nr                         VARCHAR(30);
            mat_wendat_dbrid                   INTEGER;

        --- Verkauf. Artikel 'W.13.N-272.371 /C'
            mat_ag_nr                         VARCHAR(30);
            mat_ag_preis                      NUMERIC;  -- Verkaufspreis
            mat_ag_id                         NUMERIC;
            stk_mgcode_me_cod                 INTEGER;
            stk_ld_ekp_mce                    INTEGER;
            p10_mgcode_me_cod                 INTEGER;
            p10_ld_ekp_mce                    INTEGER;
        --- Anfrageverwaltung
            akbtxt                            TEXT;
            akbtxtrtf                         TEXT;
            aang_alief_id                     INTEGER;
            aang_aart_id                      INTEGER;
            aang_steucode1                    INTEGER;
            aang_steuproz1                    NUMERIC(5,2);
            anfnr                             VARCHAR;
            aAng__id                          INTEGER;
    BEGIN

    --- Mengeneinheiten holen
          kg_mgcode_me_cod := (SELECT COALESCE(me_cod, 0) FROM mgcode WHERE me_bez LIKE 'Kilogramm');
          IF COALESCE(kg_mgcode_me_cod, 0) = 0 THEN
            INSERT INTO mgcode (me_cod, me_iso, me_bez) VALUES (2, 'kg', 'Kilogramm')
            RETURNING me_cod INTO kg_mgcode_me_cod;
          END IF;
          kg_ld_ekp_mce := (SELECT COALESCE(m_id, 0) FROM artmgc WHERE m_ak_nr = mat_aknr AND m_mgcode = kg_mgcode_me_cod);
          IF COALESCE(kg_ld_ekp_mce, 0) = 0 THEN
            INSERT INTO artmgc (m_ak_nr, m_mgcode, m_uf) VALUES (mat_aknr, kg_mgcode_me_cod, '1.2')
            RETURNING m_id INTO kg_ld_ekp_mce;
          END IF;

          s3m_mgcode_me_cod := (SELECT COALESCE(me_cod, 0) FROM mgcode WHERE me_bez LIKE 'Stange 3 Meter');
          IF COALESCE(s3m_mgcode_me_cod, 0) = 0 THEN
            INSERT INTO mgcode (me_cod, me_iso, me_bez) VALUES (50, 'St 3m', 'Stange 3 Meter')
            RETURNING me_cod INTO s3m_mgcode_me_cod;
          END IF;
          s3m_ld_ekp_mce := (SELECT COALESCE(m_id, 0) FROM artmgc WHERE m_ak_nr = mat_aknr AND m_mgcode = s3m_mgcode_me_cod);
          IF COALESCE(s3m_ld_ekp_mce, 0) = 0 THEN
            INSERT INTO artmgc (m_ak_nr, m_mgcode, m_uf) VALUES (mat_aknr, s3m_mgcode_me_cod, '0.3333')
            RETURNING m_id INTO s3m_ld_ekp_mce;
          END IF;

          stk_mgcode_me_cod := (SELECT COALESCE(me_cod, 0) FROM mgcode WHERE me_bez LIKE 'Stück');
          IF COALESCE(stk_mgcode_me_cod, 0) = 0 THEN
            INSERT INTO mgcode (me_cod, me_iso, me_bez) VALUES (1, 'Stk', 'Stück')
            RETURNING me_cod INTO stk_mgcode_me_cod;
          END IF;
          stk_ld_ekp_mce := (SELECT COALESCE(m_id, 0) FROM artmgc WHERE m_ak_nr = mat_aknr AND m_mgcode = stk_mgcode_me_cod);
          IF COALESCE(stk_ld_ekp_mce, 0) = 0 THEN
            INSERT INTO artmgc (m_ak_nr, m_mgcode, m_uf) VALUES (mat_aknr, stk_mgcode_me_cod, '0.2')
            RETURNING m_id INTO stk_ld_ekp_mce;
          END IF;

          p10_mgcode_me_cod := kg_mgcode_me_cod; -- 'Kilogramm'
          p10_ld_ekp_mce := (SELECT COALESCE(m_id, 0) FROM artmgc WHERE m_ak_nr = art_welle AND m_mgcode = p10_mgcode_me_cod);
          IF COALESCE(p10_ld_ekp_mce, 0) = 0 THEN
            INSERT INTO artmgc (m_ak_nr, m_mgcode, m_uf) VALUES (art_welle, p10_mgcode_me_cod, '0.1')
            RETURNING m_id INTO p10_ld_ekp_mce;
          END IF;
     --Konstanten-Initialisierungen
    --VERKAUF
      --Verkaufsaufträge
       --Auftrag von AUTO-AG  zum 01. des Vormonats über 65 Getriebe ...
             --                   zum Heute über 90 Getriebe,
             ---                Eine Auftragsnummer mit 2 Positionen
             ---                Zwei Einzelaufträge
             --                   zum 11. des Folgemonats über 75 Getriebe,
             --                   zum 21. des Folgemonats über 80 Getriebe

         S:=getnumcirclenr('eauftg');

         INSERT INTO auftg
          (ag_astat, ag_nr, ag_pos, ag_bda, ag_lkn, ag_aknr, ag_stk, ag_preis, ag_mcv,
                ag_datum, ag_bdat, ag_kdatum, ag_ldatum,
                ag_steucode, ag_ustpr, ag_prkl, ag_kukl)
           VALUES --4 Einzelaufträge Getriebe
              --Rückstand 1 Woche Auftragseingang -60
              ('E', S, 1, myident, adk_kunde_auto, art_getriebe, 65, 876.54, art_getriebe_mgcid,
                dat_current_minus_2_monat, dat_current_minus_2_monat, dat_current_minus_1_monat, dat_current_minus_1_week,
                steu_steucode_auftg, 19, 1, 1),
              --Heute Auftragseingang -60
              ('E', S, 2, myident, adk_kunde_auto, art_getriebe, 90, 876.54, art_getriebe_mgcid,
                dat_current_minus_2_monat, dat_current_minus_2_monat, dat_current_minus_1_monat, current_date,
                steu_steucode_auftg, 19, 1, 1),
              --in 15 Tagen, Auftragseingang -7
              ('E', getnumcirclenr('eauftg'), 1, myident, adk_kunde_auto, art_getriebe, 75, 876.54, art_getriebe_mgcid,
                dat_current_minus_5_day, dat_current_minus_5_day, current_date, dat_current_plus_15_day,
                steu_steucode_auftg, 19, 1, 1),
              --in 30 Tagen, Auftragseingang Heute
              ('E', getnumcirclenr('eauftg'), 1, myident, adk_kunde_auto, art_getriebe, 80, 876.54  , art_getriebe_mgcid,
                current_date, current_date, dat_current_plus_1_monat, dat_current_plus_1_monat,
                steu_steucode_auftg, 19, 1, 1),
              ('E', getnumcirclenr('eauftg'), 1, myident, adk_kunde_auto, art_welle, 5, 2559.40  , art_welle_mgcid_palt_10,
                current_date, current_date, dat_current_plus_1_monat, dat_current_plus_1_monat,
                steu_steucode_auftg, 19, 1, 1);
       --GETRIEBE-GMBH bestellt 520 Ersatzteile "Welle" zum 01. des Folgemonats, AE heute
         --auftg_welle_ag_id_plus15
         INSERT INTO auftg
          (ag_astat, ag_nr, ag_pos, ag_bda, ag_lkn, ag_aknr, ag_stk, ag_preis, ag_mcv,
                ag_datum, ag_bdat, ag_kdatum, ag_ldatum,
                ag_steucode, ag_ustpr, ag_prkl, ag_kukl)
          VALUES
              ('E', getnumcirclenr('eauftg'), 1, myident, adk_kunde_getr, art_welle, 520, 18.75  , art_welle_mgcid,
                current_date, current_date, dat_current_plus_15_day, dat_current_plus_15_day,
                steu_steucode_auftg, 19, 1, 1)
          RETURNING ag_id INTO auftg_welle_ag_id_plus15;

            -- und GETRIEBE-GMBH bekommt noch einen Rahmenauftrag über 100 Getriebe zum Preis von 950 EUR
                  -- auftg_welle_ag_id_palt10
         INSERT INTO auftg
          (ag_astat, ag_nr, ag_pos, ag_bda, ag_lkn, ag_aknr, ag_stk, ag_preis, ag_mcv,
                ag_datum, ag_bdat, ag_kdatum, ag_ldatum,
                ag_steucode, ag_ustpr, ag_prkl, ag_kukl)
          VALUES
              ('E', getnumcirclenr('eauftg'), 1, myident, adk_kunde_auto, art_welle, 5, 187.50  , art_welle_mgcid_palt_10,
                current_date, current_date, dat_current_plus_1_monat, dat_current_plus_1_monat,
                steu_steucode_auftg, 19, 1, 1)
          RETURNING ag_id INTO auftg_welle_ag_id_palt10;


       --Rahmenaufträge (R)     GETRIEBE-GMBH bekommt noch einen Rahmenauftrag über 950 Getriebe zum Preis von 776.54 EUR
        --Rahmenauftrag anlegen: Getriebe GmbH Wellen
         --auftg_rahmen_ag_id
         INSERT INTO auftg                                                                                                 --RA16-00001
          (ag_astat, ag_nr, ag_pos, ag_bda, ag_lkn, ag_aknr, ag_stk, ag_preis, ag_mcv,
                ag_datum, ag_bdat, ag_kdatum, ag_ldatum,
                ag_steucode, ag_ustpr, ag_prkl, ag_kukl)
           VALUES
            ('R', getnumcirclenr('rauftg'), 1, rahmen_ident, adk_kunde_getr, art_getriebe, 750, 776.54  , art_getriebe_mgcid,
                dat_current_minus_2_monat, dat_current_minus_2_monat, dat_current_minus_2_monat, dat_folgejahr,  --achtung kdatum und ldatum im rahmen = rahmenlaufzeit von-bis
                steu_steucode_auftg, 19, 1, 1)
           RETURNING ag_id INTO auftg_rahmen_ag_id;

        --Und bestellt 50 Stück aus dem Rahmen
          INSERT INTO auftg  --Verwendung auftg_rahmen_ag_id
          (ag_astat, ag_nr, ag_pos, ag_bda, ag_lkn, ag_aknr, ag_stk, ag_preis, ag_mcv,
                ag_rahmen_ag_id,
                ag_datum, ag_bdat, ag_kdatum, ag_ldatum,
                ag_steucode, ag_ustpr, ag_prkl, ag_kukl)
          VALUES
            ('E', getnumcirclenr('eauftg'), 1, rahmen_ident, adk_kunde_getr, art_getriebe, 50, 776.54  , art_getriebe_mgcid,
                auftg_rahmen_ag_id,
                current_date, current_date, dat_current_plus_1_monat, dat_current_plus_1_monat,
                steu_steucode_auftg, 19, 1, 1);
    -------------------------------------------------------------------------------------
    --EINKAUF, Produktion(ABK) (E und I)
     ----- Einkauf 'E', 'R' : Sensor Bordcomputer mit SerienNr
     --Rahmenbestellung Zahnrad mit Abruf
         INSERT INTO ldsdok
          (ld_code, ld_auftg, ld_pos,
           ld_ekref, ld_bem,
           ld_kn,
           ld_aknr,
           ld_stk, ld_mce, ld_ep,
           ld_datum, ld_term, ld_terml,
           ld_steucode, ld_steuproz)
         SELECT
           'R', (TEinkauf.Generate_Bestellnummer_Ext('R')).nummer, 1,
           rahmen_ident, rahmen_ident,
           adk_lief_zersp,
           art_zahnrad,
           1000, art_zahnrad_mgcid, 21.5,
           current_date-130, current_date-100, current_date+265,
           9, 19
         RETURNING ld_id, ld_auftg||'/'||ld_pos INTO ldsdokr_ld_id_art_rahnrad, s;
         INSERT INTO twawi.ldsdok_abzu(az_type, az_pos, az_abz_id, az_parent_id, az_anzahl, az_betrag) VALUES ('E', 9001, 9001, ldsdokr_ld_id_art_rahnrad, 1, 15); --'uRT-Transport-Abzu-Betrag 15'
         INSERT INTO twawi.ldsdok_abzu(az_type, az_pos, az_abz_id, az_parent_id, az_anzahl, az_betrag) VALUES ('E', 9003, 9003, ldsdokr_ld_id_art_rahnrad, 1, 75); --'uRT-Rüstkosten-Matzeugnis B 75 S 7'

         --Abruf 1
         INSERT INTO ldsdok
          (ld_code, ld_auftg, ld_pos, ld_rhl_nr, ld_kn, ld_aknr, ld_stk, ld_ep, ld_datum, ld_term, ld_terml, ld_mce, ld_ekref, ld_steucode, ld_steuproz)
         SELECT
          'E', (TEinkauf.Generate_Bestellnummer_Ext('E')).nummer, 1, s, adk_lief_zersp, art_zahnrad, 50, 21.5, dat_current_minus_5_day, current_date, current_date, art_zahnrad_mgcid, rahmen_ident, 9, 19
         RETURNING ld_id, ld_auftg, dbrid INTO ldsdokr_ld_id_art_eahnrad, ldsdoke_ld_auftg, ldsdoke_dbrid;
         INSERT INTO twawi.ldsdok_abzu (az_type, az_pos, az_abz_id, az_parent_id, az_anzahl, az_betrag) VALUES ('E', 9001, 9001, ldsdokr_ld_id_art_eahnrad, 1, 15); --'uRT-Transport-Abzu-Betrag 15'
         INSERT INTO twawi.ldsdok_abzu (az_type, az_pos, az_abz_id, az_parent_id, az_anzahl, az_betrag) VALUES ('E', 9003, 9003, ldsdokr_ld_id_art_eahnrad, 1, 75); --'uRT-Rüstkosten-Matzeugnis B 75 S 7'

         --- Eingangsrechnungsnummer
         ldsdoke_erg_nr := getnumcirclenr('eingrechnr');
         --- Dokument für Einkaufposition anlegen
         ldsdoke_ltd_dokunr := nextval('ldsdok_ld_dokunr_seq');
         PERFORM TBeleg.EingrechDokumentFromLdsdok(ldsdoke_dbrid::INTEGER, ldsdoke_erg_nr);
         --- Eingangsrechnungsposition anlegen
         PERFORM TBeleg.BelegPosFromLdsDok('ERG', ldsdoke_dbrid, ldsdoke_erg_nr, 50);

         --Abruf 2
         INSERT INTO ldsdok
          (ld_code, ld_auftg, ld_pos, ld_rhl_nr, ld_kn, ld_aknr, ld_stk, ld_ep, ld_datum, ld_term, ld_mce, ld_ekref, ld_steucode, ld_steuproz)
         SELECT
          'E', (TEinkauf.Generate_Bestellnummer_Ext('E')).nummer, 1, s, adk_lief_zersp, art_zahnrad, 50, 21.5, current_date, dat_current_plus_1_monat, art_zahnrad_mgcid, rahmen_ident, 9, 19
         RETURNING ld_id INTO ldsdokr_ld_id_art_eahnrad;
         INSERT INTO twawi.ldsdok_abzu(az_type, az_pos, az_abz_id, az_parent_id, az_anzahl, az_betrag) VALUES ('E', 9001, 9001, ldsdokr_ld_id_art_eahnrad, 1, 15); --'uRT-Transport-Abzu-Betrag 15'
         INSERT INTO twawi.ldsdok_abzu(az_type, az_pos, az_abz_id, az_parent_id, az_anzahl, az_betrag) VALUES ('E', 9003, 9003, ldsdokr_ld_id_art_eahnrad, 1, 75); --'uRT-Rüstkosten-Matzeugnis B 75 S 7'

     --Getriebesensor eine Bestellung mit 3 Positionen
        S:= (TEinkauf.Generate_Bestellnummer_Ext('E')).nummer;
        INSERT INTO ldsdok
          (ld_code, ld_auftg, ld_pos, ld_kn, ld_aknr, ld_stk, ld_ep, ld_datum, ld_term, ld_terml, ld_termv, ld_mce, ld_ekref, ld_steucode, ld_steuproz)
         SELECT
          'E', S, 1, adk_lief_elek, art_bc_getriebe_sensor, 50, 37.5, dat_current_minus_1_monat, dat_current_minus_1_week, dat_current_minus_1_week, dat_current_minus_5_day, art_bc_getriebe_sensor_mgcid, ldsdoke_sernrident, 9, 19
         RETURNING ld_id INTO ldsdoke_ld_id_getriebe_sensor;
         INSERT INTO twawi.ldsdok_abzu(az_type, az_pos, az_abz_id, az_parent_id, az_anzahl, az_betrag) VALUES ('M', 100, 100, ldsdoke_ld_id_getriebe_sensor, 0, 15); --'Kupferzuschlag'

      --2 weitere Positionen für Lagerzugang tabellarisch
        INSERT INTO ldsdok
          (ld_code, ld_auftg, ld_pos, ld_kn, ld_aknr, ld_stk, ld_ep, ld_datum, ld_term, ld_mce, ld_ekref, ld_steucode, ld_steuproz)
         SELECT
          'E', S, 2, adk_lief_elek, art_bc_platine, 3, 298, dat_current_minus_5_day, current_date, art_bc_platine_mgcid, myident, 9, 19
         RETURNING ld_id INTO ldsdoke_ld_id;
         INSERT INTO twawi.ldsdok_abzu(az_type, az_pos, az_abz_id, az_parent_id, az_anzahl, az_betrag) VALUES ('M', 100, 100, ldsdoke_ld_id, 0, 15); --'Kupferzuschlag'

      --2 weitere Positionen für Lagerzugang tabellarisch
        INSERT INTO ldsdok
          (ld_code, ld_auftg, ld_pos, ld_kn, ld_aknr, ld_stk, ld_ep, ld_term, ld_terml, ld_mce, ld_ekref, ld_steucode, ld_steuproz)
         SELECT
          'E', S, 3, adk_lief_elek, art_bc_platine, 10, 298, dat_current_plus_15_day, dat_current_plus_15_day, art_bc_platine_mgcid, myident, 9, 19
         RETURNING ld_id INTO ldsdoke_ld_id;
         INSERT INTO twawi.ldsdok_abzu(az_type, az_pos, az_abz_id, az_parent_id, az_anzahl, az_betrag) VALUES ('M', 100, 100, ldsdoke_ld_id, 0, 15); --'Kupferzuschlag'

     ----- Einkauf 'I' erstellen : Produktionsaufträge, ABK erstellen -----
       -- Interne Fertigung der ersten 22 teile für Kundenauftrag "GETRIEBE-GMBH bestellt 52 Ersatzteile "Welle" zum 01. des Folgemonats", Rückwärts terminiert
        --ldsdoki_welle_ld_id_plus15
            INSERT INTO ldsdok
              (ld_code, ld_auftg, ld_pos, ld_kn, ld_aknr, ld_stk, ld_stk_soll, ld_term, ld_ag_id, ld_mce, ld_ekref, ld_steucode, ld_steuproz)
             SELECT
              'I', (TEinkauf.Generate_Bestellnummer_Ext('I', ag_id)).nummer, 1, '#', ag_aknr, ag_stk+5, ag_stk, ag_aldatum, ag_id, ag_mcv, myident, 9, 19
             FROM auftg WHERE ag_id=auftg_welle_ag_id_plus15
             RETURNING ld_id INTO ldsdoki_welle_ld_id_plus15;

        ----- ABK erstellen -------
             SELECT
               tabk.abk__create(ld_aknr, op_ix, ld_stk, ld_stk_soll, NULL, ld_id) INTO s
             FROM ldsdok JOIN opl ON op_n=ld_aknr AND op_standard AND ld_id=ldsdoki_welle_ld_id_plus15;
        --Terminieren
         PERFORM tplanterm.abk_term(ld_abk, ld_term, True) FROM ldsdok WHERE ld_abk=s;
       -- Freien Produktionsauftrag auf Lager Welle current_date, Vorwärts terminiert
            INSERT INTO ldsdok
              (ld_code, ld_auftg, ld_pos, ld_kn, ld_aknr, ld_stk, ld_stk_soll, ld_term, ld_mce, ld_ekref, ld_steucode, ld_steuproz)
             SELECT
              'I', (TEinkauf.Generate_Bestellnummer_Ext('I')).nummer, 1, '#', art_welle, 70, 65, current_date, art_welle_mgcid, myident, 9, 19
             RETURNING ld_id INTO s;
        ----- ABK erstellen -------
             SELECT
               tabk.abk__create(ld_aknr, op_ix, ld_stk, ld_stk_soll, NULL, ld_id) INTO s
             FROM ldsdok JOIN opl ON op_n=ld_aknr AND op_standard AND ld_id=s;
        --Terminieren
         PERFORM tplanterm.abk_term(ld_abk, ld_term, True) FROM ldsdok WHERE ld_abk=s;
       -- Freien Produktionsauftrag auf Lager Welle dat_current_plus_1_monat, Rückwärts terminiert
            INSERT INTO ldsdok
              (ld_code, ld_auftg, ld_pos, ld_kn, ld_aknr, ld_stk, ld_stk_soll, ld_term, ld_mce, ld_ekref, ld_steucode, ld_steuproz)
             SELECT
              'I', (TEinkauf.Generate_Bestellnummer_Ext('I')).nummer, 1, '#', art_welle, 215, 205, dat_current_plus_1_monat, art_welle_mgcid, myident, 9, 19
             RETURNING ld_id INTO s;
        ----- ABK erstellen -------
             SELECT
               tabk.abk__create(ld_aknr, op_ix, ld_stk, ld_stk_soll, NULL, ld_id) INTO s
             FROM ldsdok JOIN opl ON op_n=ld_aknr AND op_standard AND ld_id=s;
        --Terminieren
         PERFORM tplanterm.abk_term(ld_abk, ld_term, True) FROM ldsdok WHERE ld_abk=s;
       -- Freien Produktionsauftrag auf L-Profil mit Zuschnitt dat_current_plus_1_monat, Rückwärts terminiert
            INSERT INTO ldsdok
              (ld_code, ld_auftg, ld_pos, ld_kn, ld_aknr, ld_stk, ld_term, ld_mce, ld_ekref, ld_steucode, ld_steuproz)
             SELECT
              'I', (TEinkauf.Generate_Bestellnummer_Ext('I')).nummer, 1, '#', art_lprofil, 35, dat_current_plus_15_day, art_lprofil_mgcid, 'ZUSCHNITT'|| ' - ' ||myident, 9, 19
             RETURNING ld_id INTO s;
        ----- ABK erstellen -------
             SELECT
               tabk.abk__create(ld_aknr, op_ix, ld_stk, ld_stk_soll, NULL, ld_id) INTO s
             FROM ldsdok JOIN opl ON op_n=ld_aknr AND op_standard AND ld_id=s;
        --Terminieren
         PERFORM tplanterm.abk_term(ld_abk, ld_term, True) FROM ldsdok WHERE ld_abk=s;
    ---------------------------------------------------------------------------------
    --LAGER
     --Lagerzugang für SerNr-Bestellung ldsdoke_sernrident
      INSERT INTO wendat
          (w_lds_id, w_aknr , w_lgort, w_lagort, w_lgchnr, w_zugang, w_zug_mec, w_lfsnr)
          SELECT
           ld_id, ld_aknr, 'WE', 'WE', current_date||'-'||ld_id, 50, ld_mce, ld_ekref
          FROM ldsdok WHERE ld_id=ldsdoke_ld_id_getriebe_sensor;


      --INSERT INTO wendat
      --     (w_lds_id, w_aknr , w_lgort, w_lagort, w_lgchnr, w_zugang, w_zug_mec, w_lfsnr)
      --    VALUES
      --     (ld_id, ld_aknr, 'WE', 'WE', current_date||'-'||ld_id, 15, ld_mce, ld_ekref);

      --INSERT INTO wendat
      --    (w_aknr           , w_zug_dat, w_lgort , w_lagort, w_lgchnr, w_zugang, w_zug_mec)
      --   VALUES
      --    ('Z-21435000-L-Z64', Now()   , 'ZZ0B09', 'ZZ0B09', current_date      , 1000    , 3);

    -- Lager Zu-/ Abgänge 'art_welle' 'Palette 10'
    -- Lagerzugang 5 'Palette 10'
     INSERT INTO wendat (w_l_krz, w_aknr   , w_zug_dat   , w_lgort, w_lagort, w_lgchnr, w_zugang, w_zug_mec                                         )
         VALUES
          ('#'    , art_welle, current_date, 'WE'   ,'WE'     , 'TEST 1', 5       , tartikel.me__art__artmgc__m_id__by__me_iso(art_welle, art_welle_mgcid_iso_palt_10));

     -- Lagerabgang 5 Stück
     INSERT INTO lifsch
          (l_ag_id                 , l_krz, l_krzl, l_krzf, l_aknr  , l_ldat       , l_lgort, l_lgchnr, l_abg_mec                 , l_abgg, l_inliefdok, l_dofakt)
         VALUES
          (auftg_welle_ag_id_palt10, '#'  , '#'   , '#'   , art_welle, current_date, 'WE'   , 'TEST'  , tartikel.me__art__artmgc__m_id__by__me_iso(art_welle, 'Stk'), 5     , False      , True    );

     -- Lagerabgang 1 'Palette 10'
     INSERT INTO lifsch
          (l_ag_id                 , l_krz, l_krzl, l_krzf, l_aknr  , l_ldat      , l_lgort, l_lgchnr, l_abg_mec                                          , l_abgg, l_inliefdok, l_dofakt)
         VALUES
          (auftg_welle_ag_id_palt10, '#'  , '#'   , '#'   , art_welle, current_date, 'WE'   , 'TEST' , tartikel.me__art__artmgc__m_id__by__me_iso(art_welle, art_welle_mgcid_iso_palt_10), 1     , False      , True    );
    -------------------------------------------------------------------------------------
    --- Materialbestellung und Auftrag
     --- Einkauf '1.2210 Ø14X1000'
       mat_ld_auftg   := (TEinkauf.Generate_Bestellnummer_Ext('E')).nummer;
       mat_pos    := TSystem.Settings__GetInteger('LD_POS_WIDTH');
    --- Eingangsrechnungsnummer
       mat_erg_nr := getnumcirclenr('eingrechnr');
    --- Dokument für Einkaufposition anlegen
       mat_ltd_dokunr := nextval('ldsdok_ld_dokunr_seq');
     ---
       --- Variante 1: ld_mce = tartikel.me__art__artmgc__m_id__by__ak_standard_mgc, ld_ekp_mce = tartikel.me__art__artmgc__m_id__by__ak_standard_mgc
       --- Bestellung
           mat_stk := 12;
           mat_preis  := 10;
           INSERT INTO ldsdok
             (ld_dokunr     , ld_code, ld_auftg    , ld_pos ,  ld_kn  , ld_aknr , ld_stk    , ld_datum        , ld_preis, ld_preiseinheit, ld_ep, ld_kurs, ld_mce                   , ld_steucode, ld_steuproz, ld_ekp_mce               , insert_by, insert_date)
           VALUES
             (mat_ltd_dokunr, 'E'    , mat_ld_auftg, mat_pos,  'STAHL', mat_aknr, mat_stk, current_date-130, mat_preis, 1              , 0    , 1      , tartikel.me__art__artmgc__m_id__by__ak_standard_mgc(mat_aknr), 9          , 19         , tartikel.me__art__artmgc__m_id__by__ak_standard_mgc(mat_aknr), current_user, current_date)
           RETURNING ld_id INTO mat_ld_id;
           mat_pos := mat_pos + TSystem.Settings__GetInteger('LD_POS_WIDTH');
       --- Lagerzungang
         INSERT INTO wendat
           (w_aknr  , w_lds_id , w_zug_dat         , w_lgort  , w_lagort, w_lagbereich, w_lgchnr, w_zugang   , w_zug_mec                , insert_by, insert_date)
         VALUES
           (mat_aknr, mat_ld_id, current_date - 120, 'H2 | R1', 'R1'    , 'H2'        , '187'   , mat_stk , tartikel.me__art__artmgc__m_id__by__ak_standard_mgc(mat_aknr), current_user, current_date)
         RETURNING dbrid INTO mat_wendat_dbrid;

       --- EingagsrechnungKopf anlegen
         PERFORM TBeleg.EingrechDokumentFromWendat(mat_wendat_dbrid, mat_erg_nr);

       --- Eingangsrechnungsposition anlegen
         PERFORM TBeleg.BelegPosFromWendatPos('ERG', mat_wendat_dbrid::VARCHAR, mat_erg_nr, mat_stk);
       --- Variante 1. Ende

     --- Variante 2: ld_mce = tartikel.me__art__artmgc__m_id__by__ak_standard_mgc, ld_ekp_mce = s3m_ld_ekp_mce
       mat_stk := 12;
       mat_preis  := 30;
         INSERT INTO ldsdok
           (ld_dokunr     , ld_code, ld_auftg    , ld_pos , ld_kn  , ld_aknr , ld_stk    , ld_datum        , ld_preis, ld_preiseinheit, ld_ep, ld_kurs, ld_mce                    , ld_steucode, ld_steuproz, ld_ekp_mce    , insert_by, insert_date)
         VALUES
           (mat_ltd_dokunr, 'E'    , mat_ld_auftg, mat_pos, 'STAHL', mat_aknr, mat_stk, current_date-130, mat_preis, 1              , 0    , 1      , tartikel.me__art__artmgc__m_id__by__ak_standard_mgc(mat_aknr), 9          , 19         , s3m_ld_ekp_mce, current_user, current_date)
         RETURNING ld_id INTO mat_ld_id;

         mat_pos  := mat_pos + TSystem.Settings__GetInteger('LD_POS_WIDTH');

       --- Lagerzungang
       INSERT INTO wendat
         (w_aknr  , w_lds_id , w_zug_dat         , w_lgort  , w_lagort, w_lagbereich, w_lgchnr, w_zugang  , w_zug_mec                , insert_by, insert_date)
       VALUES
         (mat_aknr, mat_ld_id, current_date - 120, 'H2 | R1', 'R1'    , 'H2'        , '187'   , mat_stk, tartikel.me__art__artmgc__m_id__by__ak_standard_mgc(mat_aknr), current_user, current_date)
       RETURNING dbrid INTO mat_wendat_dbrid;

      --- Eingangsrechnungsposition anlegen
        PERFORM TBeleg.BelegPosFromWendatPos('ERG', mat_wendat_dbrid::VARCHAR, mat_erg_nr, mat_stk);
      --- Variante 2. Ende

     --- Variante 3: ld_mce = s3m_ld_ekp_mce, ld_ekp_mce = tartikel.me__art__artmgc__m_id__by__ak_standard_mgc
       --- Bestellung
         mat_stk := 4;
         mat_preis  := 10;
           INSERT INTO ldsdok
             (ld_dokunr     , ld_code, ld_auftg    , ld_pos , ld_kn  , ld_aknr , ld_stk    , ld_datum        , ld_preis, ld_preiseinheit, ld_ep, ld_kurs, ld_mce        , ld_steucode, ld_steuproz, ld_ekp_mce               , insert_by, insert_date)
           VALUES
             (mat_ltd_dokunr, 'E'    , mat_ld_auftg, mat_pos, 'STAHL', mat_aknr, mat_stk, current_date-130, mat_preis, 1              , 0    , 1      , s3m_ld_ekp_mce, 9          , 19         , tartikel.me__art__artmgc__m_id__by__ak_standard_mgc(mat_aknr), current_user, current_date)
         RETURNING ld_id INTO mat_ld_id;

         mat_pos  := mat_pos + TSystem.Settings__GetInteger('LD_POS_WIDTH');
       --- Lagerzungang
            INSERT INTO wendat
            (w_aknr  , w_lds_id , w_zug_dat         , w_lgort  , w_lagort, w_lagbereich, w_lgchnr, w_zugang  , w_zug_mec     , insert_by, insert_date)
          VALUES
            (mat_aknr, mat_ld_id, current_date - 120, 'H2 | R1', 'R1'    , 'H2'        , '187'   , mat_stk, s3m_ld_ekp_mce, current_user, current_date)
          RETURNING dbrid INTO mat_wendat_dbrid;

       --- Eingangsrechnungsposition anlegen
         PERFORM TBeleg.BelegPosFromWendatPos('ERG', mat_wendat_dbrid::VARCHAR, mat_erg_nr, mat_stk);
       --- Variante 3. Ende

     --- Variante 4: ld_mce = s3m_ld_ekp_mce, ld_ekp_mce = kg_ld_ekp_mce
       --- Bestellung
         mat_stk := 4;
         mat_preis  := 8.3333;
           INSERT INTO ldsdok
             (ld_dokunr     , ld_code, ld_auftg    , ld_pos , ld_kn  , ld_aknr , ld_stk    , ld_datum        , ld_preis, ld_preiseinheit, ld_ep, ld_kurs, ld_mce        , ld_steucode, ld_steuproz, ld_ekp_mce   , insert_by, insert_date)
           VALUES
             (mat_ltd_dokunr, 'E'    , mat_ld_auftg, mat_pos, 'STAHL', mat_aknr, mat_stk, current_date-130, mat_preis, 1              , 0    , 1      , s3m_ld_ekp_mce, 9          , 19         , kg_ld_ekp_mce, current_user, current_date)
         RETURNING ld_id INTO mat_ld_id;

       --- Lagerzungang
           INSERT INTO wendat
           (w_aknr  , w_lds_id , w_zug_dat         , w_lgort  , w_lagort, w_lagbereich, w_lgchnr, w_zugang , w_zug_mec      , insert_by, insert_date)
         VALUES
           (mat_aknr, mat_ld_id, current_date - 120, 'H2 | R1', 'R1'    , 'H2'        , '187'   , mat_stk, s3m_ld_ekp_mce, current_user, current_date)
         RETURNING dbrid INTO mat_wendat_dbrid;

       --- Eingangsrechnungsposition anlegen
         PERFORM TBeleg.BelegPosFromWendatPos('ERG', mat_wendat_dbrid::VARCHAR, mat_erg_nr, mat_stk);
       --- Variante 4. Ende

   --- Verkauf art_welle = 'W.13.N-272.371 /C' anlegen
       mat_pos    := TSystem.Settings__GetInteger('AG_POS_WIDTH');
       mat_ag_nr  := getnumcirclenr('eauftg');

    --- Dokument für Auftrag anlegen
      mat_ltd_dokunr := nextval('auftg_ag_dokunr_seq');

    --- Variante 1: ag_mcv = tartikel.me__art__artmgc__m_id__by__ak_standard_mgc, ag_vkp_mce = tartikel.me__art__artmgc__m_id__by__ak_standard_mgc
      --- Auftrag anlegen
        mat_stk := 20;
        mat_ag_preis  := 400;
        INSERT INTO auftg
          (ag_astat, ag_nr    , ag_pos, ag_dokunr, ag_lkn      , ag_krzl       , ag_krzf       , ag_kontakt  , ag_bdat     , ag_aknr  , ag_stk , ag_stkres , ag_datum    , ag_preis    , ag_mcv                    , ag_vkp,  ag_vkp_mce               , ag_kdatum        , ag_aldatum       , ag_steucode, ag_ustpr, ag_prkl, ag_kukl, ag_kurs, insert_by   , insert_date)
        VALUES
          ('E'     , mat_ag_nr, mat_pos, mat_ltd_dokunr, adk_kunde_getr, adk_kunde_getr, adk_kunde_getr, current_user, current_date, art_welle, mat_stk, mat_stk   , current_date, mat_ag_preis, tartikel.me__art__artmgc__m_id__by__ak_standard_mgc(art_welle), 0     , tartikel.me__art__artmgc__m_id__by__ak_standard_mgc(art_welle), current_date + 21, current_date + 19, 3          , 19      , 1      , 1      , 1      , current_user, current_date)
        RETURNING ag_id INTO mat_ag_id;
        mat_pos := mat_pos + TSystem.Settings__GetInteger('AG_POS_WIDTH');

      --- Lagerzugang
          INSERT INTO wendat
          (w_aknr   , w_zug_dat         , w_lgort  , w_lagort, w_lagbereich, w_lgchnr, w_zugang  , w_zug_mec     , insert_by, insert_date)
        VALUES
          (art_welle, current_date - 120, 'H3 | R2', 'R2'    , 'H3'        , '297'   , mat_stk, tartikel.me__art__artmgc__m_id__by__ak_standard_mgc(art_welle), current_user, current_date)
        RETURNING dbrid INTO mat_wendat_dbrid;

      --- Lagerabgang für angelegte Verkaufsauftrag
        INSERT INTO lifsch
          (l_krz         , l_krzl         , l_krzf       , l_aknr   , l_ag_id  , l_ldat      , l_lgort  , l_lgchnr, l_abg_mec                 , l_abgg , insert_by, insert_date)
        VALUES
          (adk_kunde_getr, adk_kunde_getr, adk_kunde_getr, art_welle, mat_ag_id, current_date, 'H2 | R1', '187'   , tartikel.me__art__artmgc__m_id__by__ak_standard_mgc(art_welle), mat_stk, current_user, current_date)
        RETURNING dbrid INTO mat_lifsch_dbrid;
      --- Lieferscheinkopf anlegen
        mat_beld_dokunr := getnumcirclenr('lifsch');
        PERFORM TBeleg.LiefDokFromLagAb(mat_lifsch_dbrid, mat_beld_dokunr);
      --- Lieferscheinpos. anlegen
        mat_lfs_pos_id := TBeleg.LiefPosFromLagAb(mat_lifsch_dbrid, mat_beld_dokunr, mat_stk);
      --- Rechnungkopf anlegen
        mat_be_bnr := tfaktura.belkopf__from_adk__create(adk_kunde_getr, 'R', 1);
      --- Rechnungpos. anlegen
        PERFORM tfaktura.belzeil__from_lifsch__create(mat_be_bnr, mat_beld_dokunr, mat_lfs_pos_id);
      --- Variante 1. Ende

    --- Variante 2: ag_mcv = tartikel.me__art__artmgc__m_id__by__ak_standard_mgc, ag_vkp_mce = p10_ld_ekp_mce
      --- Auftrag anlegen
        mat_stk := 20;
        mat_ag_preis  := 4000;
        INSERT INTO auftg
          (ag_astat, ag_nr    , ag_pos, ag_dokunr, ag_lkn        , ag_krzl       , ag_krzf       , ag_kontakt  , ag_bdat     , ag_aknr  , ag_stk , ag_stkres , ag_datum    , ag_preis    , ag_mcv                    , ag_vkp,  ag_vkp_mce   , ag_kdatum        , ag_aldatum       , ag_steucode, ag_ustpr, ag_prkl, ag_kukl, ag_kurs, insert_by   , insert_date)
        VALUES
          ('E'     , mat_ag_nr, mat_pos, mat_ltd_dokunr, adk_kunde_getr, adk_kunde_getr, adk_kunde_getr, current_user, current_date, art_welle, mat_stk, mat_stk   , current_date, mat_ag_preis, tartikel.me__art__artmgc__m_id__by__ak_standard_mgc(art_welle), 0     , p10_ld_ekp_mce, current_date + 21, current_date + 19, 3          , 19      , 1      , 1      , 1      , current_user, current_date)
        RETURNING ag_id INTO mat_ag_id;
        mat_pos := mat_pos + TSystem.Settings__GetInteger('AG_POS_WIDTH');

      --- Lagerzungang
          INSERT INTO wendat
          (w_aknr   , w_zug_dat         , w_lgort  , w_lagort, w_lagbereich, w_lgchnr, w_zugang  , w_zug_mec     , insert_by, insert_date)
        VALUES
          (art_welle, current_date - 120, 'H3 | R2', 'R2'    , 'H3'        , '297'   , mat_stk, tartikel.me__art__artmgc__m_id__by__ak_standard_mgc(art_welle), current_user, current_date)
        RETURNING dbrid INTO mat_wendat_dbrid;

      --- Lagerabgang für angelegte Verkaufsauftrag
        INSERT INTO lifsch
          (l_krz         , l_krzl         , l_krzf       , l_aknr   , l_ag_id  , l_ldat      , l_lgort  , l_lgchnr, l_abg_mec                 , l_abgg , insert_by, insert_date)
        VALUES
          (adk_kunde_getr, adk_kunde_getr, adk_kunde_getr, art_welle, mat_ag_id, current_date, 'H3 | R2', '297'   , tartikel.me__art__artmgc__m_id__by__ak_standard_mgc(art_welle), mat_stk, current_user, current_date)
        RETURNING dbrid INTO mat_lifsch_dbrid;
      --- Lieferscheinpos. anlegen
        mat_lfs_pos_id := TBeleg.LiefPosFromLagAb(mat_lifsch_dbrid, mat_beld_dokunr, mat_stk);
      --- Rechnungpos. anlegen
        PERFORM tfaktura.belzeil__from_lifsch__create(mat_be_bnr, mat_beld_dokunr, mat_lfs_pos_id);
      --- Variante 2. Ende

    --- Variante 3: ag_mcv = p10_ld_ekp_mce, ag_vkp_mce = tartikel.me__art__artmgc__m_id__by__ak_standard_mgc
      --- Auftrag anlegen
        mat_stk := 2;
        mat_ag_preis  := 400;
        INSERT INTO auftg
          (ag_astat, ag_nr    , ag_pos , ag_dokunr, ag_lkn        , ag_krzl       , ag_krzf       , ag_kontakt  , ag_bdat     , ag_aknr  , ag_stk , ag_stkres , ag_datum    , ag_preis    , ag_mcv        , ag_vkp, ag_vkp_mce               , ag_kdatum        , ag_aldatum       , ag_steucode, ag_ustpr, ag_prkl, ag_kukl, ag_kurs, insert_by   , insert_date)
        VALUES
          ('E'     , mat_ag_nr, mat_pos, mat_ltd_dokunr, adk_kunde_getr, adk_kunde_getr, adk_kunde_getr, current_user, current_date, art_welle, mat_stk, mat_stk   , current_date, mat_ag_preis, p10_ld_ekp_mce, 0     , tartikel.me__art__artmgc__m_id__by__ak_standard_mgc(art_welle), current_date + 21, current_date + 19, 3          , 19      , 1      , 1      , 1      , current_user, current_date)
        RETURNING ag_id INTO mat_ag_id;
        mat_pos := mat_pos + TSystem.Settings__GetInteger('AG_POS_WIDTH');

      --- Lagerzungang
          INSERT INTO wendat
          (w_aknr   , w_zug_dat         , w_lgort  , w_lagort, w_lagbereich, w_lgchnr, w_zugang, w_zug_mec     , insert_by, insert_date)
        VALUES
          (art_welle, current_date - 120, 'H3 | R2', 'R2'    , 'H3'        , '297'   , mat_stk , p10_ld_ekp_mce, current_user, current_date)
        RETURNING dbrid INTO mat_wendat_dbrid;

      --- Lagerabgang für angelegte Verkaufsauftrag
        INSERT INTO lifsch
          (l_krz         , l_krzl         , l_krzf       , l_aknr   , l_ag_id  , l_ldat      , l_lgort  , l_lgchnr, l_abg_mec     , l_abgg , insert_by, insert_date)
        VALUES
          (adk_kunde_getr, adk_kunde_getr, adk_kunde_getr, art_welle, mat_ag_id, current_date, 'H3 | R2', '297'   , p10_ld_ekp_mce, mat_stk, current_user, current_date)
        RETURNING dbrid INTO mat_lifsch_dbrid;
      --- Lieferscheinpos. anlegen
        mat_lfs_pos_id := TBeleg.LiefPosFromLagAb(mat_lifsch_dbrid, mat_beld_dokunr, mat_stk);
      --- Rechnungpos. anlegen
        PERFORM tfaktura.belzeil__from_lifsch__create(mat_be_bnr, mat_beld_dokunr, mat_lfs_pos_id);
      --- Variante 3. Ende

    --- Variante 4: ag_mcv = p10_ld_ekp_mce, ag_vkp_mce = p10_ld_ekp_mce
      --- Auftrag anlegen
        mat_stk := 2;
        mat_ag_preis  := 4000;
        INSERT INTO auftg
          (ag_astat, ag_nr    , ag_pos , ag_dokunr, ag_lkn        , ag_krzl       , ag_krzf       , ag_kontakt  , ag_bdat     , ag_aknr  , ag_stk , ag_stkres , ag_datum    , ag_preis    , ag_mcv        , ag_vkp,  ag_vkp_mce   , ag_kdatum        , ag_aldatum       , ag_steucode, ag_ustpr, ag_prkl, ag_kukl, ag_kurs, insert_by   , insert_date)
        VALUES
          ('E'     , mat_ag_nr, mat_pos, mat_ltd_dokunr, adk_kunde_getr, adk_kunde_getr, adk_kunde_getr, current_user, current_date, art_welle, mat_stk, mat_stk   , current_date, mat_ag_preis, p10_ld_ekp_mce, 0     , p10_ld_ekp_mce, current_date + 21, current_date + 19, 3          , 19      , 1      , 1      , 1      , current_user, current_date)
        RETURNING ag_id INTO mat_ag_id;
        mat_pos := mat_pos + TSystem.Settings__GetInteger('AG_POS_WIDTH');

      --- Lagerzungang
          INSERT INTO wendat
          (w_aknr   , w_zug_dat         , w_lgort  , w_lagort, w_lagbereich, w_lgchnr, w_zugang, w_zug_mec     , insert_by, insert_date)
        VALUES
          (art_welle, current_date - 120, 'H3 | R2', 'R2'    , 'H3'        , '297'   , mat_stk , p10_ld_ekp_mce, current_user, current_date)
        RETURNING dbrid INTO mat_wendat_dbrid;

        --- Lagerabgang für angelegte Verkaufsauftrag
        INSERT INTO lifsch
          (l_krz         , l_krzl         , l_krzf       , l_aknr   , l_ag_id  , l_ldat      , l_lgort  , l_lgchnr, l_abg_mec     , l_abgg , insert_by, insert_date)
        VALUES
          (adk_kunde_getr, adk_kunde_getr, adk_kunde_getr, art_welle, mat_ag_id, current_date, 'H3 | R2', '297'   , p10_ld_ekp_mce, mat_stk, current_user, current_date)
        RETURNING dbrid INTO mat_lifsch_dbrid;
      --- Lieferscheinpos. anlegen
        mat_lfs_pos_id := TBeleg.LiefPosFromLagAb(mat_lifsch_dbrid, mat_beld_dokunr, mat_stk);
      --- Rechnungpos. anlegen
        PERFORM tfaktura.belzeil__from_lifsch__create(mat_be_bnr, mat_beld_dokunr, mat_lfs_pos_id);
      --- Variante 4. Ende
    -------------------------------------------------------------------------------------
    --- Anfrageverwaltung. Anfrage erstellen
     INSERT INTO anfrage (anf_nr) VALUES (getnumcirclenr('anfrage'))
     RETURNING anf_nr INTO anfnr;

     ----- 'Z-21435000-L-Z64'
     --- Artikel anlegen
     INSERT INTO anfart (aart_ak_nr , aart_anf_nr, aart_menge, aart_m_id, aart_pos) VALUES (art_zahnrad, anfnr, 50, stk_mgcode_me_cod, COALESCE((SELECT MAX(COALESCE(aart_pos, 0)) + 1 FROM anfart WHERE aart_anf_nr = anfnr), 1))
     RETURNING aart_id INTO aang_aart_id;

     ---   'ZERSP'
     --- Anfragelieferant anlegen
     INSERT INTO anflief (alief_anf_nr, alief_lkn) VALUES (anfnr, adk_lief_zersp)
     RETURNING alief_id INTO aang_alief_id;

     --- Steuercode, Steuerprozent
     SELECT A1_WUCO, steu_proz INTO aang_steucode1, aang_steuproz1 FROM adk1 JOIN steutxt ON steu_z = a1_wuco WHERE a1_krz = adk_lief_zersp;

     --- Artikel Zusatztexte
     SELECT aArt_txt, aArt_txt_rtf    -- Laut Erzeugungsskript 'Angebotstext, vorgefüllt aus Anfragepositionstext, bearbeitbar, übernommen in Bestellung'
      INTO akbtxt, akbtxtrtf FROM anfart WHERE aart_id = aang_aart_id;
   --  SELECT
   --     (tartikel.adtx_getArtTxtLang(ak_nr, 'EK', adk_lief_zersp)).txt    AS ak_bestxt,
   --     (tartikel.adtx_getArtTxtLang(ak_nr, 'EK', adk_lief_zersp)).txtrtf AS ak_bestxt_rtf
   --   INTO akbtxt, akbtxtrtf FROM art WHERE ak_nr = art_zahnrad;

     --- Angebot 'ZERSP' erstellen
     INSERT INTO anfangebot
      (aang_alief_id, aang_aart_id, aang_datum, aang_txt, aang_txt_rtf, aang_steucode, aang_steuproz, aang_lieferzeit, aang_preis)
     VALUES
      (aang_alief_id, aang_aart_id, current_date, akbtxt, akbtxtrtf, aang_steucode1, aang_steuproz1,
      -- wtf
       (SELECT e_lfzt  FROM epreis WHERE e_aknr = art_zahnrad AND e_lkn = adk_lief_stahl),
       (SELECT e_preis FROM epreis WHERE e_aknr = art_zahnrad AND e_lkn = adk_lief_stahl)
      )
     RETURNING aAng_id  INTO aAng__id;

     INSERT INTO twawi.anfangebot_abzu(az_type, az_pos, az_abz_id, az_parent_id, az_anzahl, az_betrag) VALUES ('E', 9001, 9001, aAng__id, 1, 15); --'uRT-Transport-Abzu-Betrag 15'
     INSERT INTO twawi.anfangebot_abzu(az_type, az_pos, az_abz_id, az_parent_id, az_anzahl, az_betrag) VALUES ('E', 9003, 9003, aAng__id, 1, 75); --'uRT-Rüstkosten-Matzeugnis B 75 S 7'
     -----
     --- 'STAHL'
     --- Anfragelieferant anlegen
     INSERT INTO anflief (alief_anf_nr, alief_lkn) VALUES (anfnr, adk_lief_stahl)
     RETURNING alief_id INTO aang_alief_id;

     --- Steuercode, Steuerprozent
     SELECT A1_WUCO, steu_proz INTO aang_steucode1, aang_steuproz1 FROM adk1 JOIN steutxt ON steu_z = a1_wuco WHERE a1_krz = adk_lief_stahl;

     --- Artikel Zusatztexte
    -- SELECT aArt_txt, aArt_txt_rtf    -- Laut Erzeugungsskript 'Angebotstext, vorgefüllt aus Anfragepositionstext, bearbeitbar, übernommen in Bestellung'
    --  INTO akbtxt, akbtxtrtf FROM anfart WHERE aart_id = aang_aart_id;
     --SELECT
     --   (tartikel.adtx_getArtTxtLang(ak_nr, 'EK', adk_lief_stahl)).txt    AS ak_bestxt,
     --   (tartikel.adtx_getArtTxtLang(ak_nr, 'EK', adk_lief_stahl)).txtrtf AS ak_bestxt_rtf
     -- INTO akbtxt, akbtxtrtf FROM art WHERE ak_nr = art_zahnrad;

     --- Angebot 'STAHL' erstellen
     INSERT INTO anfangebot
      (aang_alief_id, aang_aart_id, aang_datum, aang_txt, aang_txt_rtf, aang_steucode, aang_steuproz, aang_lieferzeit, aang_preis)
     VALUES
      (aang_alief_id, aang_aart_id, current_date, akbtxt, akbtxtrtf, aang_steucode1, aang_steuproz1,
      -- wtf
       (SELECT e_lfzt  FROM epreis WHERE e_aknr = art_zahnrad AND e_lkn = adk_lief_stahl),
       (SELECT e_preis FROM epreis WHERE e_aknr = art_zahnrad AND e_lkn = adk_lief_stahl)
      )
      RETURNING aAng_id  INTO aAng__id;

     INSERT INTO twawi.anfangebot_abzu(az_type, az_pos, az_abz_id, az_parent_id, az_anzahl, az_betrag) VALUES ('E', 9001, 9001, aAng__id, 1, 15); --'uRT-Transport-Abzu-Betrag 15'
     INSERT INTO twawi.anfangebot_abzu(az_type, az_pos, az_abz_id, az_parent_id, az_anzahl, az_betrag) VALUES ('E', 9003, 9003, aAng__id, 1, 75); --'uRT-Rüstkosten-Matzeugnis B 75 S 7'
   -----

    END $$ LANGUAGE plpgsql;
--Einkauf Sonstiges: Bestellanforderungen etc
  DO $$
    --Einkauf Sonstiges
     --Bestellanforderung
    DECLARE
        --Datum --TODO: ACHTUNG ALLE DATUM: ABFANGEN DAS AUF WOCHENENDE
            dat_current_plus_1_monat    DATE:=current_date + interval '1 month'; --achtung dat_monat_folgemonat_erster
        --Artikel
            art_getriebe                VARCHAR :='G.PKW.A-1168534 /A';
            art_getriebe_mgcid          INTEGER :=tartikel.me__art__artmgc__m_id__by__ak_standard_mgc(art_getriebe);
            art_welle                   VARCHAR :='W.13.N-272.371 /C';
            art_welle_mgcid             INTEGER :=tartikel.me__art__artmgc__m_id__by__ak_standard_mgc(art_welle);
            art_getriebe_sensor         VARCHAR :='E.B.PKW.A-1168534-0100 /A';
            art_getriebe_sensor_mgcid   INTEGER :=tartikel.me__art__artmgc__m_id__by__ak_standard_mgc(art_getriebe_sensor);
        --Projekt
            banf_pjnr                   VARCHAR:=EXTRACT(year FROM current_date)::VARCHAR||'.013-W13';
    BEGIN

         INSERT INTO bestanftxt (ba_nr, ba_termweek, ba_dat, ba_titel, ba_txt) VALUES
          (banf_pjnr, NULL, current_date+30, 'Entwicklung Welle W.13.N-272.371 /C',
           'Projekt beachten' ||E'\n\n'
            ||'Bedarfe an Konstruktionsmitteln, Sensorik' ||E'\n'
            ||'Materialbedarfe zur Konstruktion, Tests usw.' ||E'\n'
            ||'Keine Gefahrstoffe, diese in DO-XXXX'
            );

        INSERT INTO bestanfpos
          (bap_pos, bap_banr, bap_aknr, bap_menge, bap_mecod, bap_termin, bap_an_nr, bap_anfrage)
        VALUES
          (1, banf_pjnr, '1.2210 Ø14X1000', 15, 4, dat_current_plus_1_monat, banf_pjnr, true);

        INSERT INTO bestanfpos
          (bap_pos, bap_banr, bap_aknr, bap_menge, bap_mecod, bap_termin, bap_an_nr)
        VALUES
          (2, banf_pjnr, 'D.W.13.1100002', 8, 1, dat_current_plus_1_monat, banf_pjnr);

        INSERT INTO bestanfpos
          (bap_pos, bap_banr, bap_aknr, bap_menge, bap_mecod, bap_termin, bap_an_nr)
        VALUES
          (3, banf_pjnr, 'Z-21435000-L-Z64', 6, 1, dat_current_plus_1_monat, banf_pjnr);
     --
     END $$ LANGUAGE plpgsql;
--

--- Verkauf in 2. Mengeneinheit
  DO $$  --
     DECLARE
    adk_kunde_getr    VARCHAR       :='GETRIEBE-GMBH';
      art_nr       VARCHAR(40)      := 'W.13.B-2356-89-1';
      me_cod_stng3    INTEGER;    --  "St 3m";"Stange 3 Meter"
      me_cod_plt10    INTEGER;    --  "Palt. 10";"Palette 10 Stück"
      m_id_stng3    INTEGER;
      m_id_plt10    INTEGER;
      menge          INTEGER;
      preis          NUMERIC;
      my_nr             VARCHAR;
      my_pos      INTEGER;
      my_dokunr        INTEGER;
      my_agid      INTEGER;
      my_lifsch_dbrid  VARCHAR(32);
      my_beld_dokunr  VARCHAR(30);
      my_wendat_dbrid  INTEGER;
      my_be_bnr        VARCHAR(15);
      my_lfs_pos_id    INTEGER;
      my_lagort        VARCHAR        := 'R1';
      my_lagbereich    VARCHAR        := 'H2';
      my_lgchnr        VARCHAR        := 'CH-1';

   BEGIN

  --- Artikel anlegen, wenn der nicht angelegt ist
    INSERT INTO art (ak_ac, ak_nr, ak_bez)
     SELECT 'PR1001', art_nr, 'Welle Nut 56'
     WHERE NOT EXISTS(SELECT true FROM art WHERE ak_nr = art_nr);

  --- Artikelmengeneinheiten
    me_cod_stng3 := (SELECT COALESCE(me_cod, 0) FROM mgcode WHERE me_bez LIKE 'Stange 3 Meter');
    IF COALESCE(me_cod_stng3, 0) = 0 THEN
      INSERT INTO mgcode (me_cod, me_iso, me_bez) VALUES (50, 'St 3m', 'Stange 3 Meter')
      RETURNING me_cod INTO me_cod_stng3;
    END IF;

    me_cod_plt10 := (SELECT COALESCE(me_cod, 0) FROM mgcode WHERE me_bez LIKE 'Palette 10 Stück');
    IF COALESCE(me_cod_plt10, 0) = 0 THEN
      INSERT INTO mgcode (me_cod, me_iso, me_bez) VALUES (52, 'Palt. 10', 'Palette 10 Stück')
      RETURNING me_cod INTO me_cod_plt10;
    END IF;

    m_id_stng3 := (SELECT COALESCE(m_id, 0) FROM artmgc WHERE m_ak_nr = art_nr AND m_mgcode = me_cod_stng3);
    IF COALESCE(m_id_stng3, 0) = 0 THEN
      INSERT INTO artmgc (m_ak_nr, m_mgcode, m_uf) VALUES (art_nr, me_cod_stng3, '0.2')
      RETURNING m_id INTO m_id_stng3;
    END IF;

    m_id_plt10 := (SELECT COALESCE(m_id, 0) FROM artmgc WHERE m_ak_nr = art_nr AND m_mgcode = me_cod_plt10);
    IF COALESCE(m_id_plt10, 0) = 0 THEN
      INSERT INTO artmgc (m_ak_nr, m_mgcode, m_uf) VALUES (art_nr, me_cod_plt10, '0.1')
      RETURNING m_id INTO m_id_plt10;
    END IF;

  --- Verkauf anlegen. Verkaufsmengeneinheit = 'Palette 10 Stück'
     my_nr   := getnumcirclenr('eauftg');
     my_pos    := TSystem.Settings__GetInteger('AG_POS_WIDTH');
     --- Dokument für Einkaufposition anlegen
     my_dokunr := nextval('auftg_ag_dokunr_seq');
     ---
     menge  := 10;
     preis  := 1000;
     INSERT INTO auftg
       (ag_astat, ag_nr, ag_pos, ag_dokunr, ag_lkn        , ag_krzl       , ag_krzf       , ag_kontakt  , ag_bdat     , ag_aknr, ag_stk, ag_stkres, ag_datum    , ag_preis, ag_mcv    , ag_vkp,  ag_vkp_mce, ag_kdatum        , ag_aldatum       , ag_steucode, ag_ustpr, ag_prkl, ag_kukl, ag_kurs, insert_by   , insert_date)
     VALUES
       ('E'     , my_nr, my_pos, my_dokunr, adk_kunde_getr, adk_kunde_getr, adk_kunde_getr, current_user, current_date, art_nr , menge , menge    , current_date, preis   , m_id_plt10, 0     , m_id_plt10 , current_date + 21, current_date + 19, 3          , 19      , 1      , 1      , 1      , current_user, current_date)
     RETURNING ag_id INTO my_agid;

  --- Lagerzungang. Mengeneinheit = 'Palette 10 Stück'
      INSERT INTO wendat
      (w_aknr, w_zug_dat         , w_lgort                            , w_lagort , w_lagbereich , w_lgchnr , w_zugang, w_zug_mec , insert_by, insert_date)
    VALUES
      (art_nr, current_date - 120, my_lagbereich || ' | ' || my_lagort, my_lagort, my_lagbereich, my_lgchnr, menge   , m_id_plt10, current_user, current_date)
    RETURNING dbrid INTO my_wendat_dbrid;

  --- Lagerabgang für angelegte Verkaufsauftrag. Mengeneinheit = 'Stange 3 Meter'
    menge  := 20;
    INSERT INTO lifsch
      (l_krz         , l_krzl         , l_krzf       , l_aknr, l_ag_id, l_ldat      , l_lgort                            , l_lgchnr , l_abg_mec , l_abgg , insert_by   , insert_date)
    VALUES
      (adk_kunde_getr, adk_kunde_getr, adk_kunde_getr, art_nr, my_agid, current_date, my_lagbereich || ' | ' || my_lagort, my_lgchnr, m_id_stng3, menge  , current_user, current_date)
    RETURNING dbrid INTO my_lifsch_dbrid;

  --- Lieferscheinkopf anlegen
    my_beld_dokunr := getnumcirclenr('lifsch');
    PERFORM TBeleg.LiefDokFromLagAb(my_lifsch_dbrid, my_beld_dokunr);
  --- Lieferscheinpos. anlegen
    my_lfs_pos_id := TBeleg.LiefPosFromLagAb(my_lifsch_dbrid, my_beld_dokunr, menge);
  --- Rechnungkopf anlegen
    my_be_bnr := tfaktura.belkopf__from_adk__create(adk_kunde_getr, 'R', 1);
  --- Rechnungpos. anlegen
    PERFORM tfaktura.belzeil__from_lifsch__create(my_be_bnr, my_beld_dokunr, my_lfs_pos_id);
  --- Verkauf anlegen. Ende

  END $$ LANGUAGE plpgsql;
---

--- Prüfprotokoll anlegen
 --- Prüfmittel (Artikel) anlegen
 INSERT INTO art
      (ak_ac,     ak_nr,          ak_fertigung, ak_bez,                            ak_znr,      ak_idx, ak_standard_mgc, ak_bfr, ak_hest, ak_vkpbas, ak_vkprund, ak_vkpbasfix, ak_nrhl)
  VALUES
      ('PM1001', 'WZB-0513-001', true,          'Lehre - Größtmaß d10,29',         null,        '01',   1,               1,      0,       0,         0.01,       null,         'WZB-0513-001'),
      ('PM1001', 'WZB-0513-002', true,          'Lehre - Kleinstmaß d10,23',       null,        '01',   1,               1,      0,       0,         0.01,       null,         'WZB-0513-002'),
      ('PM1001',  '00082571',    false,         'Hommel-Etamic C505, Nr 10070580', null,         null,  1,               5,      0,       0,         0.01,       null,         '00082571'),
      ('PM1001',  '293-145',     false,         'Bügelmessschraube 0-25mm',        null,         null,  1,               7,      0,       0,         0.01,       null,         '293-145'),
      ('PM1001',  '500-181-30',  false,         'Messschieber',                    null,         null,  1,               7,      0,       0,         0.01,       null,         '500-181-30'),
      ('PM1001',  '486000M1,6',  false,         'Gewinde- Grenz-Lehrdorn 6H M1,6', null,         null,  1,               1,      60.32,   0,         0.01,       null,         '486000M1,6'),
      ('PM1001',  '500-706-20',  false,         'Messschieber',                    '500-706-20', null,  1,               1,      125,     137.5,     0.01,       121,          '500-706-20');
 --- Kostenstelle anlegen
 INSERT INTO ksv(ks_abt, ks_bks  , ks_sts, ks_gss, ks_stsr, ks_gssr)
  VALUES ('QS-001' , 'Qualitätssicherung', 75    , 70    , 85     , 80);

  --- Prüfmittel / Inventar anlegen
  DO $$
  DECLARE   rec   RECORD;
    num   INTEGER := 0;
   BEGIN
    FOR rec IN (  SELECT
                  ak_nr
                FROM art
                  JOIN artcod ON ac_n = ak_ac AND ac_i = 25
                  LEFT JOIN artpr ON pr_aknr = ak_nr
                WHERE pr_aknr IS NULL) LOOP
       num := num + 1000;
       INSERT INTO artpr (pr_aknr, pr_pmnr)
        VALUES
           (rec.ak_nr, num + 1),
           (rec.ak_nr, num + 2),
           (rec.ak_nr, num + 3),
           (rec.ak_nr, num + 4),
           (rec.ak_nr, num + 5);
    END LOOP;
   END $$;

 CREATE OR REPLACE FUNCTION z_99_demo.op2__add__oplpm(
      _op_ix INTEGER,
      _a2_id INTEGER DEFAULT NULL
 ) RETURNS VOID AS $$

  DECLARE
      _o2_n      INTEGER;
      _o2_id      INTEGER;
      _pm_id      INTEGER;
  BEGIN

     DELETE FROM op2 WHERE o2_ix = _op_ix AND o2_ks = 'QS-001';

     --- AG-Nr suchen
     IF EXISTS(SELECT true FROM op2 WHERE o2_ix = _op_ix) THEN
        SELECT o2_n + 10 INTO _o2_n FROM op2 WHERE o2_ix = _op_ix ORDER BY o2_n DESC LIMIT 1;
     ELSE
        _o2_n := 10;
     END IF;
     --- neue Qualitätssicherung-AG anlegen
     INSERT INTO op2
        ( o2_ix, o2_n, o2_txt                 , o2_ks, o2_tr, o2_th, o2_tn )
      VALUES
        ( _op_ix,   _o2_n,   'Qualitätssicherung Prüfprotokoll erstellen', 'QS-001',  0.5,     5, 2 )
      RETURNING o2_id INTO _o2_id;

     --- Pruefplan Pos. 1
     INSERT INTO oplpm_data ( pm_a2_id, pm_op2_id, pm_pmnr, pm_pnkt                   , pm_part       , pm_nenn  , pm_tol1, pm_tol2, pm_tol3  , pm_ma, pm_pi, pm_intv_typ )
      VALUES                ( _a2_id  ,_o2_id    , 1      , 'Länge Absatz'            , '500-181-30'  , '67.5'   , '0.5'  , '-0.5' , null     , 'mm' , '10 ', 10 )
     RETURNING pm_id INTO _pm_id;

     IF _a2_id IS NOT NULL THEN
        --- Messwerte Pos. 1
        UPDATE oplpm_mw SET
             mw_messwert = '67.51',
             mw_pruefer = current_user,
             mw_pr_pmnr = ( SELECT COALESCE( ( SELECT pr_pmnr FROM artpr WHERE pr_aknr iLIKE '500-181-30' LIMIT 1 ), null ) )
        WHERE mw_pm_id = _pm_id;
     END IF;
     ---
     --- Pruefplan Pos. 2
     INSERT INTO oplpm_data ( pm_a2_id, pm_op2_id, pm_pmnr, pm_pnkt                   , pm_part       , pm_nenn  , pm_tol1, pm_tol2, pm_tol3  , pm_ma, pm_pi, pm_intv_typ )
      VALUES                ( _a2_id  ,_o2_id    , 2      , 'Absatz 1 Ø'              , '293-145'     , '10.45'  , '0.02' , '-0.02', null     , 'mm' , '20 ', 10)
     RETURNING pm_id INTO _pm_id;
     IF _a2_id IS NOT NULL THEN
        --- Messwerte Pos. 2
        UPDATE oplpm_mw SET
             mw_messwert = '10.45',
             mw_pruefer = current_user,
             mw_pr_pmnr = ( SELECT COALESCE( ( SELECT pr_pmnr FROM artpr WHERE pr_aknr iLIKE '293-145' LIMIT 1 ), null ) )
        WHERE mw_pm_id = _pm_id;
     END IF;
     ---
     --- Pruefplan Pos. 3
     INSERT INTO oplpm_data ( pm_a2_id, pm_op2_id, pm_pmnr, pm_pnkt                   , pm_part       , pm_nenn  , pm_tol1, pm_tol2, pm_tol3  , pm_ma, pm_pi, pm_intv_typ )
      VALUES                ( _a2_id  ,_o2_id    , 3      , ''                        , '00082571'    , '2'      , '0.3'  , '0'    , null     , 'mm' , '5  ', 10 )
     RETURNING pm_id INTO _pm_id;
     IF _a2_id IS NOT NULL THEN
        --- Messwerte Pos. 3
        UPDATE oplpm_mw SET
             mw_messwert = '2.2',
             mw_pruefer = current_user,
             mw_pr_pmnr = ( SELECT COALESCE( ( SELECT pr_pmnr FROM artpr WHERE pr_aknr iLIKE '00082571' LIMIT 1 ), null ) )
        WHERE mw_pm_id = _pm_id;
     END IF;
     ---
     --- Pruefplan Pos. 4
     INSERT INTO oplpm_data ( pm_a2_id, pm_op2_id, pm_pmnr, pm_pnkt                   , pm_part       , pm_nenn  , pm_tol1, pm_tol2, pm_tol3  , pm_ma, pm_pi, pm_intv_typ )
      VALUES                ( _a2_id  ,_o2_id    , 4      , 'Welle Gewinde'           , '486000M1,6'  , 'M9x0,75', null   , null   , null     , 'mm' , '50 ', 10 )
     RETURNING pm_id INTO _pm_id;
     IF _a2_id IS NOT NULL THEN
        --- Messwerte Pos. 4
        UPDATE oplpm_mw SET
             mw_messwert = 'True',
             mw_pruefer = current_user,
             mw_pr_pmnr = ( SELECT COALESCE( ( SELECT pr_pmnr FROM artpr WHERE pr_aknr iLIKE '486000M1,6' LIMIT 1 ), null ) )
        WHERE mw_pm_id = _pm_id;
     END IF;
     ---
     --- Pruefplan Pos. 5
     INSERT INTO oplpm_data ( pm_a2_id, pm_op2_id, pm_pmnr, pm_pnkt                   , pm_part       , pm_nenn  , pm_tol1, pm_tol2, pm_tol3  , pm_ma, pm_pi, pm_intv_typ )
      VALUES                ( _a2_id  ,_o2_id    , 5      , 'Ø'                       , 'WZB-0513-001', '6.7'    , '0'    , '-0.1' , null     , 'mm' , '10 ', 10 )
     RETURNING pm_id INTO _pm_id;
     IF _a2_id IS NOT NULL THEN
        --- Messwerte Pos. 5
        UPDATE oplpm_mw SET
             mw_messwert = '6.65',
             mw_pruefer = current_user,
             mw_pr_pmnr = ( SELECT COALESCE( ( SELECT pr_pmnr FROM artpr WHERE pr_aknr iLIKE 'WZB-0513-001' LIMIT 1 ), null ) )
        WHERE mw_pm_id = _pm_id;
     END IF;
     ---
     --- Pruefplan Pos. 6
     INSERT INTO oplpm_data ( pm_a2_id, pm_op2_id, pm_pmnr, pm_pnkt                   , pm_part       , pm_nenn  , pm_tol1, pm_tol2, pm_tol3  , pm_ma, pm_pi, pm_intv_typ )
      VALUES                ( _a2_id  ,_o2_id    , 6      , 'Ø'                       , 'WZB-0513-002', '6.7'    , '0.05' , '0'    , null     , 'mm' , '10 ', 10 )
     RETURNING pm_id INTO _pm_id;
     IF _a2_id IS NOT NULL THEN
        --- Messwerte Pos. 9
        UPDATE oplpm_mw SET
             mw_messwert = '6.7',
             mw_pruefer = current_user,
             mw_pr_pmnr = ( SELECT COALESCE( ( SELECT pr_pmnr FROM artpr WHERE pr_aknr iLIKE 'WZB-0513-002' LIMIT 1 ), null ) )
        WHERE mw_pm_id = _pm_id;
     END IF;
     ---
     --- Pruefplan Pos. 7
     INSERT INTO oplpm_data ( pm_a2_id, pm_op2_id, pm_pmnr, pm_pnkt                   , pm_part       , pm_nenn  , pm_tol1, pm_tol2, pm_tol3  , pm_ma, pm_pi, pm_intv_typ )
      VALUES                ( _a2_id  ,_o2_id    , 7      , 'Dicke Flansch'           , '500-706-20'  , '6.465'  , '0.04' , '-0.04', null     , 'mm' , '100', 20 )
     RETURNING pm_id INTO _pm_id;
     IF _a2_id IS NOT NULL THEN
        --- Messwerte Pos. 9
        UPDATE oplpm_mw SET
             mw_messwert = '6.465',
             mw_pruefer = current_user,
             mw_pr_pmnr = ( SELECT COALESCE( ( SELECT pr_pmnr FROM artpr WHERE pr_aknr iLIKE '500-706-20' LIMIT 1 ), null ) )
        WHERE mw_pm_id = _pm_id;
     END IF;
     ---
     --- Pruefplan Pos. 8
     INSERT INTO oplpm_data ( pm_a2_id, pm_op2_id, pm_pmnr, pm_pnkt                   , pm_part       , pm_nenn  , pm_tol1, pm_tol2, pm_tol3  , pm_ma, pm_pi, pm_intv_typ )
      VALUES                ( _a2_id  ,_o2_id    , 8      , 'Breite Nut'              , '293-145'     , '2.5'    , '0.08' , '-0.02', null     , 'mm' , '20 ', 50 )
     RETURNING pm_id INTO _pm_id;
     IF _a2_id IS NOT NULL THEN
        --- Messwerte Pos. 9
        UPDATE oplpm_mw SET
             mw_messwert = '2.5',
             mw_pruefer = current_user,
             mw_pr_pmnr = ( SELECT COALESCE( ( SELECT pr_pmnr FROM artpr WHERE pr_aknr iLIKE '293-145' LIMIT 1 ), null ) )
        WHERE mw_pm_id = _pm_id;
     END IF;
     ---
     --- Pruefplan Pos. 9
     INSERT INTO oplpm_data ( pm_a2_id, pm_op2_id, pm_pmnr, pm_pnkt                   , pm_part       , pm_nenn  , pm_tol1, pm_tol2, pm_tol3  , pm_ma, pm_pi, pm_intv_typ )
      VALUES                ( _a2_id  ,_o2_id    , 9      , 'Absatz 1'                , '500-706-20'  , ''/*F&L*/, '0.05' , '-0.05', 'a0,05]' , 'mm' , '20 ', 30 )
     RETURNING pm_id INTO _pm_id;
     IF _a2_id IS NOT NULL THEN
        --- Messwerte Pos. 9
        UPDATE oplpm_mw SET
             mw_messwert = 'True',
             mw_pruefer = current_user,
             mw_pr_pmnr = ( SELECT COALESCE( ( SELECT pr_pmnr FROM artpr WHERE pr_aknr iLIKE '500-706-20' LIMIT 1 ), null ) )
        WHERE mw_pm_id = _pm_id;
     END IF;
     ---
     --- Pruefplan Pos. 10
     INSERT INTO oplpm_data ( pm_a2_id, pm_op2_id, pm_pmnr, pm_pnkt                   , pm_part       , pm_nenn  , pm_tol1, pm_tol2, pm_tol3  , pm_ma, pm_pi, pm_intv_typ )
      VALUES                ( _a2_id  ,_o2_id    , 10     , 'Gradheit Welle insgesamt', '500-706-20'  , ''/*F&L*/, '0.02' , '-0.02', 'gd0,02]', 'mm' , '20 ', 40 )
     RETURNING pm_id INTO _pm_id;
     IF _a2_id IS NOT NULL THEN
        --- Messwerte Pos. 10
        UPDATE oplpm_mw SET
             mw_messwert = 'True',
             mw_pruefer = current_user,
             mw_pr_pmnr = ( SELECT COALESCE( ( SELECT pr_pmnr FROM artpr WHERE pr_aknr iLIKE '500-706-20' LIMIT 1 ), null ) )
        WHERE mw_pm_id = _pm_id;
     END IF;
     ---
     RETURN;
  END $$ LANGUAGE plpgsql;

  --- Prüfprotokolle für alle ASK's anlegen
 SELECT z_99_demo.op2__add__oplpm(op_ix) FROM opl;
 ---   Verkauf, PA, ABK (für ASK = 100) anlegen
 DO $$
 DECLARE
     adk_kunde_getr               VARCHAR := 'GETRIEBE-GMBH';
     art_welle                    VARCHAR := 'W.13.N-272.371 /C';
     art_welle_mgcid              INTEGER := tartikel.me__art__artmgc__m_id__by__ak_standard_mgc( art_welle );
     dat_current_plus_15_day      DATE    := current_date+15;
     auftg_welle_ag_id_plus15     INTEGER;
     ldsdoki_welle_ld_id_plus15   INTEGER;
     agmenge                      NUMERIC( 14,6 ) := 520;
     steu_steucode_auftg          INTEGER := TSystem.Settings__Get( 'auftgsteucode' );
     a2id                         INTEGER;

  BEGIN

  INSERT INTO auftg
     (ag_astat, ag_nr, ag_pos, ag_bda, ag_lkn, ag_aknr, ag_stk, ag_preis, ag_mcv,
      ag_datum, ag_bdat, ag_kdatum, ag_ldatum,
      ag_steucode, ag_ustpr, ag_prkl, ag_kukl)
   VALUES
     ( 'E', getnumcirclenr( 'eauftg' ), 1, current_user, adk_kunde_getr, art_welle, agmenge, 18.75  , art_welle_mgcid,
       current_date, current_date, dat_current_plus_15_day, dat_current_plus_15_day,
       steu_steucode_auftg, 19, 1, 1 )
  RETURNING ag_id INTO auftg_welle_ag_id_plus15;

  INSERT INTO ldsdok
      (ld_code, ld_auftg, ld_pos, ld_kn, ld_aknr, ld_stk, ld_stk_soll, ld_term, ld_ag_id, ld_mce, ld_ekref, ld_steucode, ld_steuproz)
   SELECT
      'I', ( TEinkauf.Generate_Bestellnummer_Ext( 'I', ag_id ) ).nummer, 1, '#', ag_aknr, agmenge + 5, ag_stk, ag_aldatum, ag_id, ag_mcv, current_user, 9, 19
   FROM auftg WHERE ag_id=auftg_welle_ag_id_plus15
   RETURNING ld_id INTO ldsdoki_welle_ld_id_plus15;


   PERFORM tabk.abk__create( art_welle, 100, agmenge + 5, NULL, NULL, ldsdoki_welle_ld_id_plus15, NULL, NULL, NULL, NULL,  NULL );

   PERFORM z_99_demo.op2__add__oplpm( 100 );

 END $$;
  --- Messwerte für ASk = 100 anlegen
 SELECT z_99_demo.op2__add__oplpm( 100, ( SELECT  MAX( a2_id ) FROM ab2 JOIN abk ON ab_ix = a2_ab_ix AND ab_askix = 100 AND a2_ks = 'QS-001' ) );
  ---
---
--- #11231 Demodaten: Unterbaugruppe unter Getriebe
DO $$
  DECLARE
     --Artikel
     artnr_oelpumpe        VARCHAR :='CT-SN350L-TOP8';
     artbez_oelpumpe       VARCHAR :='Serivce/Reperatur Ölpumpe';
     art_mgcid_oelpumpe    INTEGER :=tartikel.me__art__artmgc__m_id__by__ak_standard_mgc(artnr_oelpumpe);
     artnr_kolben          VARCHAR :='CT-K255-100';
     artbez_kolben         VARCHAR :='Serivce/Reperatur Kolben';
     art_mgcid_kolben      INTEGER :=tartikel.me__art__artmgc__m_id__by__ak_standard_mgc(artnr_kolben);
     opix                  INTEGER;
     art_welle             VARCHAR :='W.13.N-272.371 /C';
     art_getriebe          VARCHAR :='G.PKW.A-1168534 /A';

  BEGIN

    INSERT INTO art (ak_ac, ak_nr, ak_bez, ak_standard_mgc, ak_lag, ak_such, ak_kunde, ak_hest, ak_vkpbas, ak_auftxt) VALUES
     ('DLINT', artnr_oelpumpe, artbez_oelpumpe, art_mgcid_oelpumpe, FALSE, 'Reperatur', '#', 350, 400, 'Komplettüberholung Ölpumpe nach 2500 Betriebsstunden'||E'\n'||'Überholung enthält:'),
     ('DLINT', artnr_kolben, artbez_kolben, art_mgcid_kolben, FALSE, 'Reperatur', '#', 350, 400, 'Komplettüberholung Ölpumpe nach 2500 Betriebsstunden'||E'\n'||'Überholung enthält:');

    --- 'Ölpumpe' - AVOR anlegen
    SELECT ROUND(MAX(op_ix) + 99,-2) INTO opix FROM opl;

    INSERT INTO opl
      (op_n          , op_ix, op_vi, op_lg)
     VALUES
      (artnr_oelpumpe, opix ,     1,     6);

    INSERT INTO op2 --Montieren Halle 1
      (o2_ix, o2_n, o2_txt                 , o2_ks, o2_tr, o2_th, o2_tn)
     VALUES
      (opix,   10,   'Komplette Montage', 'MON-001',  0.5,     5, 2);

    INSERT INTO op2 --Kontrolle
      (o2_ix, o2_n, o2_txt                                , o2_ks, o2_tr, o2_th, o2_tn)
     VALUES
      (opix ,   20,   'Standardkostenstelle QS. Kontrolle', 'QSM', 0    ,    30, 10);

    IF NOT EXISTS (SELECT true FROM ksv WHERE ks_abt LIKE 'SBM-001') THEN
       INSERT INTO ksv
         (ks_abt    , ks_bks                    , ks_sts, ks_gss, ks_stsr, ks_gssr, ks_babz     , ks_ba1, ks_babz1)
        VALUES
         ('SBM-001' , 'Ständerbohrmaschine BK33', 55    , 50    , 60     , 55     , 'Schuchardt', 1     , 'Meyer');
    ENd IF;

    --- 'Kolben' - AVOR anlegen
    opix := opix + 100;
    INSERT INTO opl
      (op_n        , op_ix, op_vi, op_lg)
     VALUES
      (artnr_kolben, opix ,     1,     6);

    INSERT INTO op2 --Kolben drehen
      (o2_ix, o2_n, o2_txt             , o2_ks    , o2_tr, o2_th, o2_tn)
     VALUES
      (opix,   10,   'Kolben eindrehen ', 'DRE-001',  0.75,     7, 1);

    INSERT INTO op2 --Bohren
      (o2_ix, o2_n, o2_txt                           , o2_ks    , o2_tr, o2_th, o2_tn)
     VALUES
      (opix ,   20,   'Löcher gem. Zeichnung bohren 3x', 'SBM-001', 0.5  , 1    , 1);

    INSERT INTO op2 -- Kolben fräsen
       (o2_ix, o2_n, o2_txt         , o2_ks    , o2_tr, o2_th, o2_tn)
     VALUES
       (opix , 30  , 'Kolben fräsen', 'FRA-001', 0.5  , 12   , 2.5);

    INSERT INTO op2 --Glühen/Härten
      (o2_ix, o2_n, o2_txt    , o2_ks    , o2_aw, o2_aknr  , o2_tr, o2_awpreis, o2_awpreisfix)
     VALUES
      (opix ,   40,   'Härten', 'GLU-001',  true, 'GLU-500', 5    , 10        , 15);

    INSERT INTO op2 --Kolben fräsen
      (o2_ix, o2_n, o2_txt         , o2_ks    , o2_tr, o2_th, o2_tn)
     VALUES
      (opix ,   50, 'Kolben fräsen', 'FRA-001', 0.25 , 7   , 1);

    --- Stückliste
    INSERT INTO stv
      (st_zn         , st_n        , st_pos, st_m, st_mgc)
     VALUES
      (artnr_oelpumpe, artnr_kolben, COALESCE((SELECT MAX(st_pos) + 10 FROM stv WHERE st_zn = artnr_oelpumpe), 10), 1   , tartikel.me__art__artmgc__m_id__by__ak_standard_mgc(artnr_kolben));

    --- Welle
    INSERT INTO stv
      (st_zn         , st_n        , st_pos, st_m, st_mgc)
     VALUES
      (artnr_oelpumpe, art_welle, COALESCE((SELECT MAX(st_pos) + 10 FROM stv WHERE st_zn = artnr_oelpumpe), 10), 1   , tartikel.me__art__artmgc__m_id__by__ak_standard_mgc(art_welle));

    INSERT INTO stv
      (st_zn               , st_n        , st_pos, st_m, st_mgc)
     VALUES
      (art_getriebe, artnr_oelpumpe, (SELECT MAX(st_pos) + 10 FROM stv WHERE st_zn = art_getriebe), 1   , tartikel.me__art__artmgc__m_id__by__ak_standard_mgc(artnr_oelpumpe));

 END $$;

 --- Vertragsmanagement
 DO $$
  DECLARE
  banf_pjnr       VARCHAR;
  vtrnr      VARCHAR(40);
  vtppos      INTEGER;
  aknr      VARCHAR(40) := '1.2210 Ø14X1000-1001';
  vtpmce      INTEGER;
  vertrag_pos_dbrid   VARCHAR(32);
  vertrag_dbrid    VARCHAR(32);
  abk_dbrid    VARCHAR(32);
  abix      INTEGER;
  mat_aknr    VARCHAR(40) := '1.2210 Ø14X1000';
 BEGIN

   vtpmce := tartikel.me__art__artmgc__m_id__by__ak_standard_mgc(aknr);

   --Projekt anlegen
   banf_pjnr := getnumcirclenr('anl');

   INSERT INTO anl (an_nr    , an_bez                                             , an_best, an_kund, an_lief, an_inst, an_hest, an_sortkrz)
   VALUES          (banf_pjnr, 'Entwicklung Welle W.13.N-272.371 /C : Werkzeugbau', 'DEMO' , 'DEMO' , '#'    , '#'    , 'DEMO' , 'DEMO'    );

   vtrnr := getnumcirclenr('vertrag');
   INSERT INTO vertrag
     (vtr_nr, vtr_art            , vtr_gegenstand  , vtr_bez  , vtr_krz, vtr_an_nr, vtr_apint,  vtr_nr_ext , vtr_apext, vtr_abschluss   , vtr_beginn       , vtr_ende         , vtr_kuendfrist, vtr_kuendfrist_interval, vtr_verlfrist, vtr_verlfrist_interval, vtr_laufverl, vtr_laufverl_interval, vtr_wert_kost, vtr_wert_erl)
   VALUES
     (vtrnr , 'vertrag_allgemein', 'Leasingvertrag', 'Leasing', 'GLU'  , banf_pjnr, 'DEMO'   , 'V.referenc', 'DEMO'   , current_date + 1, current_date + 10, current_date + 30, 15            , '1 day'                , 1            , '1 mon'               , 2           , '1 mon'              , 15000        , 2200)
   RETURNING dbrid INTO vertrag_dbrid;

   --- Vertragspositionen
   vtppos := COALESCE((SELECT Max(vtp_pos) + 10 FROM vertrag_pos WHERE vtp_vtr_nr = vtrnr), 10);
   INSERT INTO vertrag_pos
     (vtp_vtr_nr, vtp_pos, vtp_type, vtp_ak_nr, vtp_bez          , vtp_qty, vtp_mce, vtp_price)
   VALUES
     (vtrnr     , vtppos , 'A'     , aknr     , 'Lieferung Art A', 10     , vtpmce , 100)
   RETURNING dbrid INTO vertrag_pos_dbrid;

   INSERT INTO cycles
     (cyc_src_dbrid    , cyc_src_key  , cyc_begin   , cyc_end         , cyc_interval, cyc_multi)
   VALUES
     (vertrag_pos_dbrid, 'vertrag_pos', current_date, current_date + 7, '7 days'    , 1);

   vtppos := COALESCE((SELECT Max(vtp_pos) + 10 FROM vertrag_pos WHERE vtp_vtr_nr = vtrnr), 10);
   INSERT INTO vertrag_pos
     (vtp_vtr_nr, vtp_pos, vtp_type, vtp_ak_nr, vtp_bez         , vtp_qty, vtp_mce, vtp_price)
   VALUES
     (vtrnr     , vtppos , 'E'     , aknr     , 'Eigenprodukt A', 3      , vtpmce , 100)
   RETURNING dbrid INTO vertrag_pos_dbrid;

   INSERT INTO cycles
     (cyc_src_dbrid    , cyc_src_key  , cyc_begin       , cyc_end          , cyc_interval, cyc_multi)
   VALUES
     (vertrag_pos_dbrid, 'vertrag_pos', current_date + 3, current_date + 10, '1 days'    , 5);
   ---

   --- Projektplanung
   INSERT INTO abk (ab_ap_nr   , ab_tablename, ab_dbrid     , ab_askix, ab_at       , ab_et)
   VALUES          ('KONDITION', 'vertrag'   , vertrag_dbrid, 0       , current_date, current_date + 10)
   RETURNING dbrid INTO abk_dbrid;
   SELECT ab_ix INTO abix FROM abk WHERE dbrid = abk_dbrid;

   INSERT INTO cycles
     (cyc_src_dbrid, cyc_src_key, cyc_begin       , cyc_end          , cyc_interval, cyc_multi)
   VALUES
     (abk_dbrid    , 'abk'      , current_date + 3, current_date + 10, '1 days'    , 5);

   --- Projekt -< Arbeitsgang
   INSERT INTO ab2 (a2_n, a2_ab_ix, a2_at       , a2_et           , a2_ks    , a2_v_ll_dbusename, a2_ausw, a2_ende, a2_subject)
   VALUES          (10  , abix    , current_date, current_date + 2, 'FRA-001', current_user     , false  , true   , 'Rechnung legen');

   INSERT INTO ab2 (a2_n, a2_ab_ix, a2_at       , a2_et           , a2_ks    , a2_v_ll_dbusename, a2_ausw, a2_ende, a2_subject)
   VALUES          (20  , abix    , current_date, current_date + 2, 'GLU-001', current_user     , true   , false  , 'Rechnung legen');
   ---
   --- Material
   INSERT INTO auftg(ag_astat, ag_nr         , ag_kontakt  , ag_aknr , ag_stk, ag_mcv                                                       , ag_prkl, ag_kukl, ag_kurs, ag_parentabk, ag_postxt)
   VALUES           ('I'     , 'VT-' || vtrnr, current_user, mat_aknr, 1     , tartikel.me__art__artmgc__m_id__by__ak_standard_mgc(mat_aknr), 1      , 1      , 1      , abix        , 'ADD');
   ---

   INSERT INTO abk (ab_ap_nr        , ab_tablename, ab_dbrid     , ab_askix, ab_at       , ab_et)
   VALUES          ('RECHNUNG LEGEN', 'vertrag'   , vertrag_dbrid, 0       , current_date + 2, current_date + 2)
   RETURNING dbrid INTO abk_dbrid;
   SELECT ab_ix INTO abix FROM abk WHERE dbrid = abk_dbrid;

   INSERT INTO cycles
     (cyc_src_dbrid, cyc_src_key, cyc_begin       , cyc_end         , cyc_interval, cyc_multi)
   VALUES
     (abk_dbrid    , 'abk'      , current_date + 1, current_date + 5, '1 days'    , 5);

   --- Projekt -< Arbeitsgang
   INSERT INTO ab2 (a2_n, a2_ab_ix, a2_at       , a2_et           , a2_ks    , a2_v_ll_dbusename, a2_ausw, a2_ende, a2_subject)
   VALUES          (10  , abix    , current_date, current_date + 2, 'FRA-001', current_user     , false  , true   , 'Rechnung legen');

   INSERT INTO ab2 (a2_n, a2_ab_ix, a2_at       , a2_et           , a2_ks    , a2_v_ll_dbusename, a2_ausw, a2_ende, a2_subject)
   VALUES          (20  , abix    , current_date, current_date + 2, 'GLU-001', current_user     , true   , false  , 'Rechnung legen');
   ---

   INSERT INTO abk (ab_ap_nr            , ab_tablename, ab_dbrid     , ab_askix, ab_at       , ab_et)
   VALUES          ('JÄHRLICHER WARTUNG', 'vertrag'   , vertrag_dbrid, 0       , current_date -1, current_date + 1)
   RETURNING dbrid INTO abk_dbrid;
   SELECT ab_ix INTO abix FROM abk WHERE dbrid = abk_dbrid;

   INSERT INTO cycles
     (cyc_src_dbrid, cyc_src_key, cyc_begin    , cyc_end          , cyc_interval, cyc_multi)
   VALUES
     (abk_dbrid    , 'abk'      , current_date , current_date + 2, '1 days'    , 5);

   --- Projekt -< Arbeitsgang
   INSERT INTO ab2 (a2_n, a2_ab_ix, a2_at       , a2_et           , a2_ks    , a2_v_ll_dbusename, a2_ausw, a2_ende, a2_subject)
   VALUES          (10  , abix    , current_date, current_date + 2, 'FRA-001', current_user     , false  , true   , 'Rechnung legen');

   INSERT INTO ab2 (a2_n, a2_ab_ix, a2_at       , a2_et           , a2_ks    , a2_v_ll_dbusename, a2_ausw, a2_ende, a2_subject)
   VALUES          (20  , abix    , current_date, current_date + 2, 'GLU-001', current_user     , true   , false  , 'Rechnung legen');
   ---
   --- Material
   INSERT INTO auftg(ag_astat, ag_nr         , ag_kontakt  , ag_aknr , ag_stk, ag_mcv                                                       , ag_prkl, ag_kukl, ag_kurs, ag_parentabk, ag_postxt)
   VALUES           ('I'     , 'VT-' || vtrnr, current_user, mat_aknr, 2     , tartikel.me__art__artmgc__m_id__by__ak_standard_mgc(mat_aknr), 1      , 1      , 1      , abix        , 'ADD');
   ---
 END $$;
---
DO $$   --- #18026 Kalkulation virtueller Baugruppen
 BEGIN

    --- art
    INSERT INTO art ( ak_ac   , ak_fertigung, ak_nr       , ak_bez                 , ak_hest, ak_rust, ak_vkpbas, ak_res, ak_verfueg, ak_lag, ak_nrhl     , ak_auslauf )
    VALUES          ( 'PR1001', true        , 'PC-MONT'   , 'PC Montiert'          , 0      , null   , 0        , 0     , 0         , false , 'PC-MONT'   , null ),
                    ( 'KT1001', false       , 'PC-TOWER'  , 'Tower'                , 10000  , 250    , 38.68    , 1     , -1        , true  , 'PC-TOWER'  , null ),
                    ( 'KT1001', false       , 'PC-MONITOR', 'Monitor'              , 150    , 250    , 38.68    , 1     , -1        , true  , 'PC-MONITOR', null ),
                    ( 'KT1001', true        , 'PC-SET'    , 'PC: PC, Monitor, Maus', 1200   , 250    , 15000    , 0     , 0         , true  , 'PC-SET'    , null ),
                    ( 'KT1001', false       , 'PC-MAUS'   , 'Maus'                 , 50     , 250    , 38.68    , 1     , -1        , true  , 'PC-MAUS'   , current_date - 7 );
    --- opl
    INSERT INTO opl ( op_n     , op_vi, op_agk )
    VALUES          ( 'PC-MONT', '1'  , 15 );

    --- stv
    INSERT INTO stv ( st_zn    , st_n        , st_pos, st_m, st_mgc )
    VALUES          ( 'PC-SET' , 'PC-TOWER'  , 10    , 1   , tartikel.me__art__artmgc__m_id__by__ak_standard_mgc( 'PC-TOWER'   ) ),
                    ( 'PC-SET' , 'PC-MAUS'   , 20    , 1   , tartikel.me__art__artmgc__m_id__by__ak_standard_mgc( 'PC-MAUS'    ) ),
                    ( 'PC-SET' , 'PC-MONITOR', 30    , 1   , tartikel.me__art__artmgc__m_id__by__ak_standard_mgc( 'PC-MONITOR' ) ),
                    ( 'PC-MONT', 'PC-SET'    , 10    , 1   , tartikel.me__art__artmgc__m_id__by__ak_standard_mgc( 'PC-SET'     ) );

 END $$ LANGUAGE plpgsql;
---

-- END DEMO-SESSION
RESET SESSION AUTHORIZATION;
